define(["lodash", "src/utils", "src/build/Container", "src/build/Graphics", "src/build/Color", "src/build/ColorBrewer"],
function (lodash, utils, Container, Graphics, Color, ColorBrewer) {
	"use strict";

	function constructWithArray (ctor) {
		return function (aArgs) {
			var Maker = function () { ctor.apply(this, aArgs); };
			Maker.prototype = ctor.prototype;
			return new Maker();
		};
	}

	var makeColor = constructWithArray(Color);

	function unitSquare (size, aColorArgs0) {
		var aColorArgs = aColorArgs0 || [1, 1, 1, 1],
			square = new Graphics(),
			color = makeColor(aColorArgs),
			halfSize = 0.5*size;

		square.fillRect(color, [-halfSize, -halfSize, size, size]);
		return square;
	}

	function VisualMarks (args0) {
		var args = {};

		lodash.defaults(args, args0 || {}, {
			scheme : "Paired",
			classes : 12,
			opacity : 0.5
		});

		this.marks = new Container("VisualMarks");

		var classRGB = ColorBrewer[args.scheme][args.classes];

		this.colors = classRGB.map(function (rgb) {
			var colorArgs = rgb.slice(0);
			colorArgs.push(args.opacity);
			return makeColor(colorArgs);
		}.bind(this));
	}

	VisualMarks.unitSquare = unitSquare;

	utils.mixin(VisualMarks, {

		square : function (size, colorIndex0) {
			var colorIndex = colorIndex0 || 0,
				square = new Container("Mark"),
				g = new Graphics("fill"),
				halfSize = 0.5*size,
				rect = [-halfSize, -halfSize, size, size];
			g.fillRect(this.colors[colorIndex], rect);
			square.addChild(g);
			
			// Add an invisible stroke, allowing clients to dynamically display it.
			g = new Graphics("stroke");
			g.strokeRect(new Color(1, 0, 0), rect, 2);
			square.addChild(g);
			g.setAlpha(0.0);
			return square;
		},

		insertMark : function (mark, index0) {
			this.marks.addChild(mark, index0);
		},

		getMarkAtIndex : function (index) {
			var marks = this.marks.getChildren();
			return marks[index];
		},

		removeMarkAtIndex : function (index) {
			this.marks.removeChildAtIndex(index);
		},

		clearMarks : function () {
			this.marks.removeChildren();
			this.marks = null;
		},

		forEach : function (fn) {
			var marks = this.marks.getChildren();
			marks.forEach(fn);
		},

		addToDisplayItem : function (item) {
			item.getDisplayContainer().addChild(this.marks);
		},

		removeFromDisplayItem : function (item) {
			item.getDisplayContainer().removeChild(this.marks);
		}

	});

	return VisualMarks;
});